/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.api;

import com.ibm.hwmca.api.APIActivationProfileChangeEvent;
import com.ibm.hwmca.api.APIAlertEvent;
import com.ibm.hwmca.api.APICommandResponseEvent;
import com.ibm.hwmca.api.APIConnection;
import com.ibm.hwmca.api.APIEndedEvent;
import com.ibm.hwmca.api.APIExceptionStateEvent;
import com.ibm.hwmca.api.APIHardwareMessageDeleteEvent;
import com.ibm.hwmca.api.APIMessageEvent;
import com.ibm.hwmca.api.APINameChangeEvent;
import com.ibm.hwmca.api.APIObjectCreatedEvent;
import com.ibm.hwmca.api.APIObjectDestroyedEvent;
import com.ibm.hwmca.api.APIStartedEvent;
import com.ibm.hwmca.api.APIStatusChangeEvent;
import com.ibm.hwmca.api.SNMPData;
import java.util.EventObject;

public class APIEvent
extends EventObject {
    public static final int HWMCA_EVENT_COMMAND_RESPONSE = 0;
    public static final int HWMCA_EVENT_MESSAGE = 1;
    public static final int HWMCA_EVENT_STATUS_CHANGE = 2;
    public static final int HWMCA_EVENT_NAME_CHANGE = 4;
    public static final int HWMCA_EVENT_ACTIVATE_PROF_CHANGE = 8;
    public static final int HWMCA_EVENT_CREATED = 16;
    public static final int HWMCA_EVENT_DESTROYED = 32;
    public static final int HWMCA_EVENT_EXCEPTION_STATE = 64;
    public static final int HWMCA_EVENT_ENDED = 128;
    public static final int HWMCA_EVENT_HARDWARE_MESSAGE = 256;
    public static final int HWMCA_EVENT_OPSYS_MESSAGE = 512;
    public static final int HWMCA_EVENT_NO_REFRESH_MESSAGE = 1024;
    public static final int HWMCA_EVENT_STARTED = 2048;
    public static final int HWMCA_EVENT_HARDWARE_MESSAGE_DELETE = 4096;
    public static final int HWMCA_EVENT_ALERT = 8192;
    public static final int HWMCA_EVENT_ALL_EVENTS = 16383;
    private SNMPData[] _eventData = null;
    private Integer _type;

    APIEvent(Object source, SNMPData[] eventData) {
        super(source);
        APIConnection.trace("-> APIEvent(Object, SNMPData[])");
        this._eventData = eventData;
        this._type = (Integer)this._eventData[1].toObject();
        APIConnection.trace("<- APIEvent(Object, SNMPData[])");
    }

    static APIEvent getEventObject(Object source, SNMPData[] eventData) {
        APIConnection.trace("-> APIEvent.getEventObject");
        APIEvent event = null;
        Integer type = (Integer)eventData[1].toObject();
        switch (type) {
            case 0: {
                event = new APICommandResponseEvent(source, eventData);
                break;
            }
            case 1: {
                event = new APIMessageEvent(source, eventData);
                break;
            }
            case 2: {
                event = new APIStatusChangeEvent(source, eventData);
                break;
            }
            case 4: {
                event = new APINameChangeEvent(source, eventData);
                break;
            }
            case 8: {
                event = new APIActivationProfileChangeEvent(source, eventData);
                break;
            }
            case 16: {
                event = new APIObjectCreatedEvent(source, eventData);
                break;
            }
            case 32: {
                event = new APIObjectDestroyedEvent(source, eventData);
                break;
            }
            case 64: {
                event = new APIExceptionStateEvent(source, eventData);
                break;
            }
            case 128: {
                event = new APIEndedEvent(source, eventData);
                break;
            }
            case 2048: {
                event = new APIStartedEvent(source, eventData);
                break;
            }
            case 4096: {
                event = new APIHardwareMessageDeleteEvent(source, eventData);
                break;
            }
            case 8192: {
                event = new APIAlertEvent(source, eventData);
                break;
            }
            default: {
                event = new APIEvent(source, eventData);
            }
        }
        APIConnection.trace("<- APIEvent.getEventObject");
        return event;
    }

    public int getType() {
        return this._type;
    }

    public SNMPData[] getEventData() {
        return this._eventData;
    }

    public String getObjectId() {
        return this._eventData[0].toString();
    }

    public String toString() {
        String s = this.getClass().getName() + ": type=[" + this.getType() + "]; object id=[" + this.getObjectId() + "]";
        return s;
    }
}

